 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_CallRecording_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_CallRecording_Js.editInstance == false){
            var instance = new CTMobileSettings_CallRecording_Js();
            CTMobileSettings_CallRecording_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_CallRecording_Js.editInstance;
    }
},{ 
    registerUsersFilterChangeEvent:function() {

       var date = new Date();
       var month = date.getMonth()+1;
       var day = date.getDate();
       var year = date.getFullYear();
       var newdate = year + '/' + month + '/' + day;
        if(day > 7){
           day = day -7;
           if(day < 10 ){
               day = '0' + day;
           }
           if(month < 10 ){
               month = '0' + month;
           }
           var lastDate = year + '/' + month + '/' + day;
       }else{
           var month31 = [1,3,5,7,8,10,12];
           if(month > 1){
                day = 7 - day;
                month = month - 1;
                if(jQuery.inArray(month, month31) !== -1){
                    day = 31 - day;
                }else{
                    day = 30 - day;
                }
                year = year - 1;
                if(day < 10 ){
                   day = '0' + day;
                }
                if(month < 10 ){
                   month = '0' + month;
                }
                var lastDate = year + '/' + month + '/' + day;
           }else{
                day = day -7;
                month = month - 1;
                if(jQuery.inArray(month, month31) !== -1){
                    day = 31 - day;
                }else{
                    day = 30 - day;
                }
                if(day < 10 ){
                   day = '0' + day;
                }
                if(month < 10 ){
                   month = '0' + month;
                }
                var lastDate = year + '/' + month + '/' + day;
           }
       }
       var Today = newdate;
       var tempdate = date;
       tempdate.setDate(tempdate.getDate() - 1);
       var Yesterday = tempdate.getFullYear()+'/'+(tempdate.getMonth()+1)+'/'+tempdate.getDate();

       var tempdate1 = date;
       tempdate1.setDate(tempdate1.getDate() - 6);
       var last7days = tempdate1.getFullYear()+'/'+(tempdate1.getMonth()+1)+'/'+tempdate1.getDate();

       var tempdate2 = date;
       tempdate2.setDate(tempdate2.getDate() - 29);
       var last30days = tempdate2.getFullYear()+'/'+(tempdate2.getMonth()+1)+'/'+tempdate2.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
       var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
       var firstday = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var lastday = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear(), date.getMonth()-1, 1);
       var lastDay = new Date(date.getFullYear(), date.getMonth(), 0);
       var monthStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var monthEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear(), 0, 1);
       var lastDay = new Date(date.getFullYear(), 12, 0);
       var yearStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var yearEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear()-1, 0, 1);
       var lastDay = new Date(date.getFullYear()-1, 12, 0);
       var lastyearStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var lastyearEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var dateValue = firstday + ' - ' + lastday;
       jQuery('input[name="daterange"]').val(dateValue);

       var today_label = app.vtranslate('Today');
       var yesterday_label = app.vtranslate('Yesterday');
       var last_7_days_label = app.vtranslate('Last 7 Days');
       var last_30_days_label = app.vtranslate('Last 30 Days');
       var this_month_label = app.vtranslate('This Month');
       var this_year_label = app.vtranslate('This Year');
       var last_year_label = app.vtranslate('Last Year');

       var myranges = {};
       myranges[today_label] = [Today,Today];
       myranges[yesterday_label] = [Yesterday, Yesterday];
       myranges[last_7_days_label] = [last7days, Today];
       myranges[last_30_days_label] = [last30days, Today];
       myranges[this_month_label] = [firstday, lastday];
       myranges[this_year_label] = [yearStartDay, yearEndDay];
       myranges[last_year_label] = [lastyearStartDay, lastyearEndDay];

       jQuery('input[name="daterange"]').daterangepicker({    locale: {
          format: 'YYYY/MM/DD',
          separator: " - ",
          applyLabel: app.vtranslate("Apply"),
          cancelLabel: app.vtranslate("Cancel"),
          fromLabel: app.vtranslate("From"),
          toLabel: app.vtranslate("To"),
          customRangeLabel: app.vtranslate("Custom Range"),
          daysOfWeek: [
              app.vtranslate("Su"),
              app.vtranslate("Mo"),
              app.vtranslate("Tu"),
              app.vtranslate("We"),
              app.vtranslate("Th"),
              app.vtranslate("Fr"),
              app.vtranslate("Sa")
          ],
          monthNames: [
              app.vtranslate("January"),
              app.vtranslate("February"),
              app.vtranslate("March"),
              app.vtranslate("April"),
              app.vtranslate("May"),
              app.vtranslate("June"),
              app.vtranslate("July"),
              app.vtranslate("August"),
              app.vtranslate("September"),
              app.vtranslate("October"),
              app.vtranslate("November"),
              app.vtranslate("December")
          ],
        },
        ranges: myranges
        });

        jQuery("#searchbtn").on("click", function(e) {
            var usersFilter = jQuery('#usersFilter').val();
            var daterange = jQuery('#daterange').val();
            var searchtext = jQuery('#searchbox').val();
            var searchrecordid = jQuery('#searchtextvalue').val();
            var mainmodule = app.getModuleName();
            var parentmodule = app.getParentModuleName();
            var action = 'getCallRecording';
            var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&search_key=user_name&search_value="+usersFilter+"&daterange="+daterange+"&searchtext="+searchtext+"&searchrecid="+searchrecordid;
            table = jQuery('#listview-table').DataTable({
              'paging'      : true,
              'lengthChange': false,
              'searching'   : false,
              'ordering'    : false,
              'info'        : true,
              'autoWidth'   : false,
              'pageLength' : 20,
              'processing': true,
              'serverSide': true,
              'serverMethod': 'post',
              'destroy': true,
              'ajax': {
                  'url':url
              },
              "language": {
                  "sProcessing": app.vtranslate('Processing'),
                  "sEmptyTable": app.vtranslate('No data available in table'),
                  "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
                  "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
                  "oPaginate": {
                      "sFirst": app.vtranslate('First'),   
                      "sLast": app.vtranslate('Last'),  
                      "sNext":   app.vtranslate('Next'), 
                      "sPrevious": app.vtranslate('Previous'),
                  },
              },
              "columns": [
                  { "data": "label" },
                  { "data": "username" },
                  { "data": "related" },
                  { "data": "createdtime" },
                  { "data":"duration" },
                  { "data": "file" }
              ]
              }); 
        });

        var mainmodule = app.getModuleName();
        var parentmodule = app.getParentModuleName();
        var action = 'getCallRecording';
        var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action;
        table = jQuery('#listview-table').DataTable({
          'paging'      : true,
          'lengthChange': false,
          'searching'   : false,
          'ordering'    : false,
          'info'        : true,
          'autoWidth'   : false,
          'pageLength' : 20,
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'ajax': {
              'url':url
          },
          "language": {
              "sProcessing": app.vtranslate('Processing'),
              "sEmptyTable": app.vtranslate('No data available in table'),
              "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
              "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
              "oPaginate": {
                  "sFirst": app.vtranslate('First'),   
                  "sLast": app.vtranslate('Last'),  
                  "sNext":   app.vtranslate('Next'), 
                  "sPrevious": app.vtranslate('Previous'),
              },
          },
          "columns": [
            { "data": "label" },
            { "data": "username" },
            { "data": "related" },
            { "data": "createdtime" },
            { "data":"duration" },
            { "data": "file" }
          ]
          });

        jQuery("#searchbox").keyup(function() {               
            var searchvalue = $('#searchbox').val();
            if (searchvalue == "") {
                jQuery("#result ul").empty();
                jQuery('#searchtextvalue').val('');
            }else {
                var listdaterange = jQuery('#daterange').val();
                var listUsers = jQuery('#usersFilter').val();
                var postData = {
                "module": app.getModuleName(),
                "parent": app.getParentModuleName(),
                "action": 'getCallRecording',
                "mode": "listRecord",
                "daterange": listdaterange,
                "listUsers": listUsers,
                "searchtext":searchvalue
                };
            
                AppConnector.request(postData).then(
                    function(data) {
            
                    var len = data.result.length;
                    jQuery("#result ul").empty();
                    for( var i = 0; i<len; i++){
                        jQuery("#result ul").append("<li value='"+data.result[i]['id']+"'>"+data.result[i]['text']+"</li>");
                    }
                    // binding click event to li
                    jQuery("#result li").bind("click",function(){
                        setText(this);
                    });
                },function(error){
                     jQuery("#result ul").empty();
                });
            }
        });
        jQuery('#searchbox').focusout(function(){
            setTimeout(function(){ 
                jQuery('#result ul').empty();
            }, 200);
        });
        
    },

    registerAppTriggerEvent : function() {
        jQuery('.app-menu').removeClass('hide');
        var toggleAppMenu = function(type) {
            var appMenu = jQuery('.app-menu');
            var appNav = jQuery('.app-nav');
            appMenu.appendTo('#page');
            appMenu.css({
                'top' : appNav.offset().top + appNav.height(),
                'left' : 0
            });
            if(typeof type === 'undefined') {
                type = appMenu.is(':hidden') ? 'show' : 'hide';
            }
            if(type == 'show') {
                appMenu.show(200, function() {});
            } else {
                appMenu.hide(200, function() {});
            }
        };

        jQuery('.app-trigger, .app-icon, .app-navigator').on('click',function(e){
            e.stopPropagation();
            toggleAppMenu();
        });

        jQuery('html').on('click', function() {
            toggleAppMenu('hide');
        });

        jQuery(document).keyup(function (e) {
            if (e.keyCode == 27) {
                if(!jQuery('.app-menu').is(':hidden')) {
                    toggleAppMenu('hide');
                }
            }
        });

        jQuery('.app-modules-dropdown-container').hover(function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            jQuery('.dropdown').removeClass('open');
            if(dropdownContainer.length) {
                if(dropdownContainer.hasClass('dropdown-compact')) {
                    dropdownContainer.find('.app-modules-dropdown').css('top', dropdownContainer.position().top - 8);
                } else {
                    dropdownContainer.find('.app-modules-dropdown').css('top', '');
                }
                dropdownContainer.addClass('open').find('.app-item').addClass('active-app-item');
            }
        }, function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            dropdownContainer.find('.app-item').removeClass('active-app-item');
            setTimeout(function() {
                if(dropdownContainer.find('.app-modules-dropdown').length && !dropdownContainer.find('.app-modules-dropdown').is(':hover') && !dropdownContainer.is(':hover')) {
                    dropdownContainer.removeClass('open');
                }
            }, 500);

        });

        jQuery('.app-item').on('click', function() {
            var url = jQuery(this).data('defaultUrl');
            if(url) {
                window.location.href = url;
            }
        });

        jQuery(window).resize(function() {
            jQuery(".app-modules-dropdown").mCustomScrollbar("destroy");
            app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
                setHeight: $(window).height(),
                autoExpandScrollbar: true
            });
            jQuery('.dropdown-modules-compact').each(function() {
                var element = jQuery(this);
                var heightPer = parseFloat(element.data('height'));
                app.helper.showVerticalScroll(element, {
                    setHeight: $(window).height()*heightPer - 3,
                    autoExpandScrollbar: true,
                    scrollbarPosition: 'outside'
                });
            });
        });
        app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
            setHeight: $(window).height(),
            autoExpandScrollbar: true,
            scrollbarPosition: 'outside'
        });
        jQuery('.dropdown-modules-compact').each(function() {
            var element = jQuery(this);
            var heightPer = parseFloat(element.data('height'));
            app.helper.showVerticalScroll(element, {
                setHeight: $(window).height()*heightPer - 3,
                autoExpandScrollbar: true,
                scrollbarPosition: 'outside'
            });
        });
    },

    registerEventsForDownload : function(){
        jQuery('#downloadCalllogs').on('click',function(){
            var usersFilter = jQuery('#usersFilter').val();
            var daterange = jQuery('#daterange').val();
            var searchtext = jQuery('#searchbox').val();
            var searchrecordid = jQuery('#searchtextvalue').val();
            var params = {
                module: 'CTMobileSettings',
                action: 'getCallRecording',
                mode: 'ExportDataCount',
                search_key:'username',
                search_value:usersFilter,
                daterange:daterange,
                searchtext:searchtext,
                searchrecid:searchrecordid
            
            };
            app.helper.showProgress();
            app.request.post({data: params}).then(function (err, res) {
                app.helper.hideProgress();
                if(res['success'] > 0){
                    jQuery('#downloadForm').submit();
                }else{
                    app.helper.showSuccessNotification({message: app.vtranslate('No Data Available.')});
                       
                }
            
            });  
            
        });
    },
    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerUsersFilterChangeEvent(); 
        this.registerAppTriggerEvent();
        this.registerEventsForDownload();  
    }
});


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_CallRecording_Js();
    instance.registerEvents();

});


function setText(element){
    var recordid = jQuery(element).val();
    var value = jQuery(element).text();
    jQuery("#searchbox").val(value);
    jQuery("#searchtextvalue").val(recordid);
    jQuery("#result ul").empty();

    //getRouteListData(recordid);
    
} 



