<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTMobileSettings_SaveLicense_Action extends Settings_Vtiger_Basic_Action {
    
public function process(Vtiger_Request $request) {
	global $adb,$site_URL;
	$getLicenseQuery=$adb->pquery("SELECT * FROM ctmobile_license_settings");
	$numOfLicenseCount = $adb->num_rows($getLicenseQuery);
	$License_Key = trim($request->get('license_key'));
	$numofUsers = CTMobileSettings_Module_Model::getTotalCrmUsers();
	$url = CTMobileSettings_Module_Model::$CTMOBILE_CHECKLICENSE_URL;
	$ch = curl_init($url);
	$data = array( "license_key"=>$License_Key,"domain"=>$site_URL,"action"=>"activate",'num_of_crm_user'=>$numofUsers);
	curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	$res_license = curl_exec($ch);
	curl_close($ch);
	$result_response = json_decode($res_license,true);
	if($result_response['message'] == 'Activated' || $result_response['message'] == 'Already activated'){
		$premiumUserType = array('Monthly','One Time','Yearly');
		$user_type = $result_response['user_type'];
		$expirydate = $result_response['expirydate'];
		if(in_array($user_type,$premiumUserType)){
			$user_type = 'premium';
		}else{
			$user_type = 'free';
		}
		if($numOfLicenseCount > 0){
			$record=$adb->query_result($getLicenseQuery,0,'id');
			$query=$adb->pquery("UPDATE ctmobile_license_settings SET license_key=?, domain=?, expirydate=?, user_type=? WHERE id=?",array($License_Key, $site_URL, $expirydate, $user_type, $record));
			if($query){
				$result = array('code'=>2, 'msg'=>vtranslate('License Key Updated Successfully','CTMobileSettings'));
			}
		}else{
			$query=$adb->pquery("INSERT INTO ctmobile_license_settings (license_key,status,domain,expirydate,user_type) values(?,?,?,?,?)",array($License_Key,1,$site_URL,$expirydate,$user_type));
			if($query){
				$result = array('code'=>1, 'msg'=>vtranslate('License Key Inserted Successfully','CTMobileSettings'));
			}
		}								 
												   
	}else if($result_response['message'] == 'Already activated'){
		$result = array('code'=>3, 'msg'=>vtranslate('License Key Updated Successfully','CTMobileSettings'));
	}else if($result_response['message'] == 'licence has been expired'){
		$result = array('code'=>100, 'msg'=>vtranslate('You Enetered License has expired','CTMobileSettings'));
	}else if($result_response['message'] == 'Already activated in another domain'){
		$result = array('code'=>103, 'msg'=>vtranslate('Already activated in another domain','CTMobileSettings'),"domain"=>$result_response['domain'],"license_key"=>$License_Key);
	}else{
		$result = array('code'=>100, 'msg'=>vtranslate('You Enetered License is Invalid','CTMobileSettings'));
	}
	$response = new Vtiger_Response();
	$response->setEmitType(Vtiger_Response::$EMIT_JSON);
	$response->setResult($result);
	$response->emit();
}
}
?>
