<?php
/*** Portions created by IT-Solutions4You (ITS4YOU) are Copyright (C) IT-Solutions4You s.r.o.
 * ITS4YOU-CR MaSo 20/1/2014
 * A function for print the total value in words  
 * based on http://www.karlrixon.co.uk/writing/convert-numbers-to-words-with-php/
 * [CUSTOMFUNCTION|convert_number_to_words|number|CUSTOMFUNCTION] 
 * for example:
 * [CUSTOMFUNCTION|convert_number_to_words|$TOTAL$|CUSTOMFUNCTION] *     
*/
 
if(!function_exists('convert_number_to_words')){
	function convert_number_to_words($number) {
		
		$number = its4you_formatNumberFromPDF($number);
	   
	    $hyphen      = ' y ';
	    $conjunction = ' ';
	    $separator   = ', ';
	    $negative    = ' MENOS ';
	    $decimal     = ' PUNTO ';
	    $dictionary  = array(
	        0                   => 'CERO',
	        1                   => 'UN',
	        2                   => 'DOS',
	        3                   => 'TRES',
	        4                   => 'CUATRO',
	        5                   => 'CINCO',
	        6                   => 'SEIS',
	        7                   => 'SIETE',
	        8                   => 'OCHO',
	        9                   => 'NUEVE',
	        10                  => 'DIEZ',
	        11                  => 'ONCE',
	        12                  => 'DOCE',
	        13                  => 'TRECE',
	        14                  => 'CATORCE',
	        15                  => 'QUINCE',
	        16                  => 'DIECISEIS',
	        17                  => 'DIECISIETE',
	        18                  => 'DIECIOCHO',
	        19                  => 'DIECINUEVE',
	        20                  => 'VEINT',
	        30                  => 'TREINTA',
	        40                  => 'CUARENTA',
	        50                  => 'CINCUENTA',
	        60                  => 'SESENTA',
	        70                  => 'SETENTA',
	        80                  => 'OCHENTA',
	        90                  => 'NOVENTA',
	        100                 => 'CIEN',
	        500					=> 'QUINIENTOS',
	        700					=> 'SETECIENTOS',
	        900					=> 'NOVECIENTOS',
	        1000                => 'MIL',
	        1000000             => 'MILLON',
	        1000000000          => 'BILLONES',
	        1000000000000       => 'TRILLONES',
	        1000000000000000    => 'CUADRILLONES',
	        1000000000000000000 => 'QUINTILLONES'
	    );
	   
	    if (!is_numeric($number)) {
	        return false;
	    }
	   
	    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
	        // overflow
	        trigger_error(
	            'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
	            E_USER_WARNING
	        );
	        return false;
	    }
	
	    if ($number < 0) {
	        return $negative . convert_number_to_words(abs($number));
	    }
	   
	    $string = $fraction = null;
	   
	    if (strpos($number, '.') !== false) {
	        list($number, $fraction) = explode('.', $number);
	    }
	   
	    switch (true) {
	        case $number < 20:
	            $string = $dictionary[$number];
	            break;


	        case $number < 100:
	            $tens   = ((int) ($number / 10)) * 10;
	            $units  = $number % 10;
	            $string = $dictionary[$tens];
	            if ($units) 
	            {
	            	if ($tens == 20) 
	            	{
	            		$string .= 'I'. $dictionary[$units];
	            		if ($units== 1) 
	            		{
	            			$string .='O';
	            		}
	            	}else
	            	{
	            		$string .= $hyphen . $dictionary[$units];
	            	}
	            } 
	            else{
	            	if ($tens == 20) 
	            	{
	            		$string .= 'E' ;
	            	}
	            }


	            break;

	        case $number == 100:
	        	$string = $dictionary[100];
	        	break;

	        case $number < 200:
	        	$string = $dictionary[100].'TO';
	        	$remainder = $number % 100;
	        	if ($remainder) {
	                $string .= " ".convert_number_to_words($remainder);
	            }
	        	
	        	break;

	        	// case $number < 300:
	        	// $string = $dictionary[2].$dictionary[100].'s';
	        	// $remainder = $number % 100;
	        	// if ($remainder) {
	         //        $string .= " ".convert_number_to_words($remainder);
	         //    }
	        	
	        	// break;

	        	
	        // case $number < 1000:
	        //     $hundreds  = $number / 100;
	        //     $remainder = $number % 100;
	        //     $string = $dictionary[$hundreds] . $dictionary[100] . 'tos';
	        //     if ($remainder) {
	        //         $string .= $conjunction . convert_number_to_words($remainder);
	        //     }
	        //     break;


	            case $number < 1000:
	            $hundreds  = ((int)($number / 100));
	            $remainder = $number % 100;
	            $string = $dictionary[$hundreds] . $dictionary[100] . 'TOS';
	            if ($remainder) 
	            {
	            	if ($hundreds == 5) 
	            	{
	            		$string = $dictionary[500] .' '. convert_number_to_words($remainder);
	            	}
	            	elseif ($hundreds == 7) 
	            	{
	            		$string = $dictionary[700] .' '. convert_number_to_words($remainder);
	            	}
	            	elseif ($hundreds == 9) 
	            	{
	            		$string = $dictionary[900] .' '. convert_number_to_words($remainder);
	            	}
	            	else
	            	{
	            		$string .= $conjunction . convert_number_to_words($remainder);
	            	}
	            } 
	            else
	            {
	            	if ($hundreds == 5) 
	            	{
	            		$string = $dictionary[500]  ;
	            	}
	            	elseif ($hundreds == 7) 
	            	{
	            		$string = $dictionary[700];
	            	}
	            	elseif ($hundreds == 9) 
	            	{
	            		$string = $dictionary[900];
	            	}
	            }


	            break;



	        default:

	        	if ($number== 1000000) 
	        	{
	        		$string = $dictionary[1].' '.$dictionary[1000000];
	        	}else{

	            $baseUnit = pow(1000, floor(log($number, 1000)));
	            $numBaseUnits = (int) ($number / $baseUnit);
	            $remainder = $number % $baseUnit;
	            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
	            if ($remainder) {
	                $string .= $remainder < 100 ? $conjunction : $separator;
	                $string .= convert_number_to_words($remainder);
	            }
	            break;
	    }
	}
	   
	    if (null !== $fraction && is_numeric($fraction)) {
	        $string .= $decimal;
	        $words = array();
	        foreach (str_split((string) $fraction) as $number) {
	            $words[] = $dictionary[$number];
	        }
	        $string .= implode(' ', $words);
	    }
	   
	    return $string;
	}
}
