<?php

/**
 * VGS Hide Ads Banner Module
 *
 *
 * @package        VGSHideAds Module
 * @author         Conrado Maggi - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

class VGSHideAds_saveVGSHideAdsSettings_Action extends Vtiger_Action_Controller {

    public function checkPermission(Vtiger_Request $request) {
        global $current_user;
        $moduleName = $request->getModule();

        if (!is_admin($current_user)) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }
    }

    public function process(Vtiger_Request $request) {
        include_once 'vtlib/Vtiger/Module.php';
        include_once 'vtlib/Vtiger/Link.php';

        $settingsCheck = $request->get('checkbox');
        $extensionStoreModel = Vtiger_Module::getInstance('ExtensionStore');

        if($extensionStoreModel){
            try {
                if ($settingsCheck == 'true') {
    
                    //@TODO: Remove the link from vtiger settings works for both VT
                    Vtiger_Link::deleteLink($extensionStoreModel->getId(), 'HEADERSCRIPT', 'ExtensionStoreCommonHeaderScript');                
                    $responseText = 'ok';
                } else {
                    Vtiger_Link::addLink($extensionStoreModel->getId(), 'HEADERSCRIPT', 'ExtensionStoreCommonHeaderScript', 'modules/ExtensionStore/ExtensionStore.js');
                    
                    $responseText = 'ok';
                }
            } catch (Exception $exc) {
                    $responseText = 'fail';
            }
        }else{
            $responseText = 'fail';
        }



        $response = new Vtiger_Response();
        $response->setResult($responseText);
        $response->emit();
    }

}
