<?php

/**
 * Created by PhpStorm.
 * User: Stefan
 * Date: 25.05.2016
 * Time: 08:29
 */
namespace Workflow\CommunicationProvider;

use Workflow\ExecutionLogger;
use Workflow\VtUtils;

class Plivo extends \Workflow\CommunicationPlugin
{
    protected $usernameLabel = 'Auth ID';
    protected $passwordLabel = 'Auth Token';

    protected $name = 'Plivo';

    protected $supported = array(
        'sms' => true
    );

    public function SMS_check($data)
    {
        foreach($data['message_uuid'] as $uuid) {
            $response = $this->request('GET', '/Message/'.$uuid.'/');
var_dump($uuid, $response);
            if($response['message_state'] == 'delivered') {
                ExecutionLogger::getCurrentInstance()->log($uuid.': Message reached the recipient.');
                return true;
            } else {
                ExecutionLogger::getCurrentInstance()->log($uuid.': State '.$response['message_state']);
                return false;
            }
        }

    }

    public function SMS($data) {
        if(empty($data['from'])) {
            $data['from'] = $this->get('default_from');
        }

        if(substr($data['to'], 0, 2) == '00') {
            $data['to'] = '+'.ltrim($data['to'], '0');
        }

        if(substr($data['from'], 0, 2) == '00') {
            $data['from'] = '+'.ltrim($data['from'], '0');
        }

        $params = array(
            'src' => $data['from'],
            'dst' => $data['to'],
            'text' => trim($data['content']),
        );

        $response = $this->request('POST', '/Message/', $params);

        return $response;
    }

    public function test() {
        $response = $this->request('GET', '');
    }

    public function request($method, $path, $params = array()) {
        $sid = $this->get('username');
        $token = $this->get('password');

        $url = 'https://api.plivo.com/v1/Account/'.$sid.rtrim($path, '/').'/';

        try {
            $response = VtUtils::getContentFromUrl($url, $params, $method, array('successcode' => array(200, 202), 'debug' => false, 'auth' => array('user' => $sid, 'password' => $token)));
        } catch (\Exception $e) {
            if($e->getCode() == '401') {
                throw new \Exception('AuthID or Auth Token could not be verified');
            } else {
                throw $e;
            }
        }

        return VtUtils::json_decode($response);
    }

    public function getConfigFields()
    {
        $return = parent::getConfigFields(); // TODO: Change the autogenerated stub
        $return['default_from'] = array(
            'label' => 'Default SMS Sender',
            'type' => 'text',
        );

        return $return;
    }

    // Add Default Sender
    public function getDataFields($method) {
        $return = parent::getDataFields($method);
        $return['from']['placeholder'] = $this->get('default_from');
        return $return;
    }

}

\Workflow\CommunicationPlugin::register('plivio', '\\Workflow\\CommunicationProvider\\Plivo');