<?php
require_once(realpath(dirname(__FILE__).'/../autoload_wf.php'));

class WfTaskLogisticssendvehicle extends \Workflow\Task
{
    /**
     * @var \Workflow\Preset\SimpleConfig
     */
    private $_SC = null;

    protected $_envSettings = array("record_id");

    public function init()
    {
        $this->_SC = $this->addPreset("SimpleConfig", "details", array(
            'templatename' => 'mainconfig',
        ));

        if($this->isConfiguration()) {
            $this->_SC->setColumnCount(1);

            $this->_SC->addFields('providerid', 'Logistics Provider', 'provider', array(
                'provider' => 'flexxlogistics'
            ));

            if($this->_SC->has('providerid')) {
                $this->_SC->addFields('recordid', 'KFZ ID to link entry', 'template');
                $this->_SC->addFields('registration', 'Kennzeichen', 'template');
                $this->_SC->addFields('brand', 'Marke', 'template');
                $this->_SC->addFields('model', 'Modell', 'template');
                $this->_SC->addFields('maxPayloadLength', 'max. Länge Ladung (m)', 'template');
                $this->_SC->addFields('maxPayloadWeight', 'max. Gewicht Ladung (kg)', 'template');
                $this->_SC->addFields('maxWeight', 'zulässiges Gesamtgewicht (kg)', 'template');
                $this->_SC->addFields('maxAxleWeight', 'zulässiges Achsgewicht (kg)', 'template');
            }
        }

    }

    public function handleTask(&$context) {
        /* Insert here source code to execute the task */
        /**
         * @var $provider \Workflow\Plugins\ConnectionProvider\FlexxLogistics
         */
        $provider = \Workflow\ConnectionProvider::getConnection($this->_SC->get('providerid'));

        $storeContextId = $this->_SC->get('recordid');
        if(empty($storeContextId) || $storeContextId === -1) {
            $storeContextId = $context->getId();
        }

        if($context->getId() != $storeContextId) {
            $storeContext = \Workflow\VTEntity::getForId($storeContextId);
        } else {
            $storeContext = $context;
        }

        $id = $storeContext->getEntityData('vehicleid');
        if($id === -1) $id = null;

        $vehicle = array(
            'registration' => $this->_SC->get('registration'),
            'brand' => $this->_SC->get('brand'),
            'model' => $this->_SC->get('model'),
            'maxPayloadLength' => floatval($this->_SC->get('maxPayloadLength')),
            'maxPayloadWeight' => floatval($this->_SC->get('maxPayloadWeight')),
            'maxWeight' => $this->_SC->get('maxWeight'),
            'maxAxleWeight' => floatval( $this->_SC->get('maxAxleWeight'))
        );

        if(empty($id)) {
            $response = $provider->sendRequest('vehicles', $vehicle);
        } else {
            $response = $provider->sendRequest('vehicles/' . $id, $vehicle, 'PUT');
        }

        $storeContext->addEntityData('vehicleid', $response->id);

        $context->setEnvironment('record_id', $response->id, $this);

        return "yes";
    }

    public function beforeGetTaskform($viewer) {
        /* Insert here source code to create custom configurations pages */
    }
    public function beforeSave(&$values) {
        /* Insert here source code to modify the values the user submit on configuration */
    }
}
