<?php
require_once(realpath(dirname(__FILE__).'/../autoload_wf.php'));

class WfTaskOwnCloud_createshare extends \Workflow\Task
{
    /**
     * @var \Workflow\Preset\SimpleConfig
     */
    private $_SC = null;
    protected $_envSettings = array("share_id", 'share_url');

    public function init()
    {
        $this->_SC = $this->addPreset("SimpleConfig", "details", array(
            'templatename' => 'mainconfig',
        ));

        if($this->isConfiguration()) {
            $this->_SC->setColumnCount(1);

            $this->_SC->addFields('providerid', 'OwnCloud Provider', 'provider', array(
                'provider' => 'owncloud'
            ));

            $this->_SC->addFields('path', 'Path', 'template');
            $this->_SC->addFields('publicUpload', 'Public Upload', 'select', array(
                'options' => array(
                    'false' => 'Do not allow public uploads',
                    'true' => 'Allow public upload',                    
                )
            ));
            $this->_SC->addFields('passwords', 'Passwords', 'password');
            $this->_SC->addFields('expireDate', 'Expire date', 'template');
            $this->_SC->addFields('note', 'Note', 'textarea');

        }

    }
    public function handleTask(&$context) {

        if($this->_SC->has('providerid')) {
            /**
             * @var $provider \Workflow\Plugins\ConnectionProvider\OwnCloud
             */
            $provider = \Workflow\ConnectionProvider::getConnection($this->_SC->get('providerid'));

            $response = $provider->CreateShare(
                $this->_SC->get('path'),
                $this->_SC->get('publicUpload'),
                $this->_SC->get('passwords'),
                $this->_SC->get('expireDate'),
                $this->_SC->get('note')
            );

            $share_id = $response['ocs']['data']['id'];
            $share_url = $response['ocs']['data']['url'];

            $context->setEnvironment("share_id", $share_id, $this);
            $context->setEnvironment("share_url", $share_url, $this);

        }

        return "yes";
    }

    public function beforeGetTaskform($viewer) {
        /* Insert here source code to create custom configurations pages */
    }
    public function beforeSave(&$values) {
        /* Insert here source code to modify the values the user submit on configuration */
    }
}
