<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_SearchField extends CTMobile_WS_Controller {
    
    function process(CTMobile_API_Request $request) {
       global $adb,$current_user;
       $current_user = $this->getActiveUser();
       $mode=trim($request->get("mode"));
       if($mode == 'SaveField'){
            $module=trim($request->get("module"));
            $userid = trim($request->get("userid"));
            $fieldname= trim($request->get("fieldname"));

            if($module && $userid && $fieldname){
                $moduleModel = Vtiger_Module_Model::getInstance($module);
                $fieldModels = $moduleModel->getFields();
                $fieldCustomViewName = $fieldModels[$fieldname]->getCustomViewColumnName();
                // Clear data
                $adb->pquery("DELETE FROM `ctmobile_search_field` WHERE `module` = ? AND userid = ?",array($module,$userid));
                // Save selected fields
                
                $adb->pquery("INSERT INTO `ctmobile_search_field` (`module`,`fieldname`,`userid`) VALUES (?, ?, ?)",array($module,$fieldCustomViewName,$userid));

                $response = new CTMobile_API_Response();
                $message = $this->CTTranslate('Search Field save successfully');
                $response->setResult($message);
                return $response;
            }else{
                $message = $this->CTTranslate('Required Field not found');
                throw new WebServiceException(404,$message);
            }
       }else if($mode == 'getField'){
            $module=trim($request->get("module"));
            $userid = trim($request->get("userid"));
            if($module && $userid){
                $searchFieldQuery = $adb->pquery("SELECT fieldname FROM ctmobile_search_field WHERE module = ? AND ( userid = ? OR userid = ?) ORDER BY userid",array($module,'selectAll',$userid));
                if($adb->num_rows($searchFieldQuery) > 0){
                    $entityField = $adb->query_result($searchFieldQuery,0,'fieldname');
                    $entityField_array = explode(':',$entityField);
                    $entityField = $entityField_array[2];

                    $tabid = getTabid($module);
                    $entityQuery11 = $adb->pquery("SELECT * FROM vtiger_field WHERE columnname = ? and tabid= ?",array($entityField,$tabid));
                    $fieldlabel = $adb->query_result($entityQuery11,0,'fieldlabel');
                    $fieldlabel = vtranslate($fieldlabel,$module);
                }else{
                    $entityQuery = $adb->pquery("SELECT * FROM vtiger_entityname WHERE modulename = ?",array($module));
                    $entityField = $adb->query_result($entityQuery,0,'fieldname');
                    $entityField_array = explode(',',$entityField);
                    $entityField = $entityField_array[0];
                    $tabid = getTabid($module);

                    if($module == 'Documents' && $entityField == 'title'){
                       $entityField = 'notes_title';
                    }
                    if($module == 'HelpDesk' && $entityField == 'title'){
                       $entityField = 'ticket_title';
                    }

                    $entityQuery11 = $adb->pquery("SELECT * FROM vtiger_field WHERE columnname = ? and tabid= ?",array($entityField,$tabid));
                    $fieldlabel = $adb->query_result($entityQuery11,0,'fieldlabel');
                    $fieldlabel = vtranslate($fieldlabel,$module);
                }
            }else{
                $message = $this->CTTranslate('Required Field not found');
                throw new WebServiceException(404,$message);
            }

            $response = new CTMobile_API_Response();
            $response->setResult(array('fieldname'=>$entityField,'fieldlabel'=>$fieldlabel));
            return $response;
       }


    }

}