<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */


class CTMobile_WS_TeamActivityReport extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb;
		$current_user = $this->getActiveUser();
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');

		$response = new CTMobile_API_Response();
		$user_id = $request->get('user_id');
		$daterange = $request->get('daterange');
		$checkmodule = $request->get('checkmodule');
		$searchvalue = 	$request->get('searchvalue');
		$mode = $request->get('mode');
		
		if($daterange != ''){
			$date = explode(' - ',$daterange);
			$date1 = date("Y-m-d", strtotime($date[0]));
			$date2 = date("Y-m-d", strtotime($date[1]));
		}
	
		$index = trim($request->get('index'));
		$size = trim($request->get('size'));
		$limit = ($index*$size) - $size;
		
		
		$data = array();
		$markquery = "SELECT usr_route.*,entity.setype,entity.label FROM ctmobile_userderoute as usr_route INNER JOIN vtiger_crmentity as entity ON  usr_route.record = entity.crmid WHERE usr_route.record != '' ";

		if(!empty($daterange))
			$markquery.=" AND DATE(usr_route.createdtime) BETWEEN '".$date1."' AND '".$date2."' ";
		if(!empty($user_id))
			$markquery.=" AND usr_route.userid = '$user_id' ";
		if(!empty($checkmodule))
			$markquery .= " AND entity.setype = '".$checkmodule."'";	
		if(!empty($searchvalue))
			$markquery .= " AND entity.label LIKE '%".$searchvalue."%'";
		
		$markquery.= " ORDER BY usr_route.createdtime DESC";
		$totalQuery = $markquery;
		if($index != '' && $size != ''){
			$markquery.= " LIMIT $limit, $size";
		}
		
		$result1 = $adb->pquery($totalQuery,array());
		$recordsTotal = $adb->num_rows($result1);
		$result2 = $adb->pquery($markquery,array());
		$last_latitude = '';
		$last_longitude = '';
		$isLast = true;
		for($i=0;$i<$adb->num_rows($result2);$i++){
			$latitude = $adb->query_result($result2,$i,'latitude');
			$longitude = $adb->query_result($result2,$i,'longitude');
			$userid  = $adb->query_result($result2,$i,'userid');
			$userName = "";
			if($userid != ''){
				$userModel = Users_Record_Model::getInstanceById($userid,'Users');
					$userName = decode_html(decode_html($userModel->get('first_name').' '.$userModel->get('last_name')));
			}
			$recordid = $adb->query_result($result2,$i,'record');
			$action = $adb->query_result($result2,$i,'action');
			$createdtime = $adb->query_result($result2,$i,'createdtime');
			$module = $adb->query_result($result2,$i,'setype');
			$label = $adb->query_result($result2,$i,'label');

			$iconimagename = strtolower($module).'.png';
			if($action == 'edit'){
				$action = 'Updated';
				$DetaiViewurl = 'index.php?module='.$module.'&view=Detail&record='.$recordid;
				if($module == 'ModComments'){
					$iconimagename = 'chat.png';
				}
			}else{
				if($module == 'ModComments'){
					$CommentQuery = "SELECT * FROM vtiger_modcomments INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_modcomments.related_to WHERE modcommentsid = ?";
					$commentResult = $adb->pquery($CommentQuery,array($recordid));
					$setype = $adb->query_result($commentResult,0,'setype');
					$crmid = $adb->query_result($commentResult,0,'crmid');
					$relatedLabel = $adb->query_result($commentResult,0,'label');
					$DetaiViewurl = 'index.php?module='.$setype.'&relatedModule='.$module.'&view=Detail&record='.$crmid.'&mode=showRelatedList';
					
					$action = 'Commented On '.$relatedLabel;
					//$module = '';
					$iconimagename = 'chat.png';
				}else{
					$action = 'Created';
					$DetaiViewurl = 'index.php?module='.$module.'&view=Detail&record='.$recordid;
				}
				
			}
			$created_time = Vtiger_Util_Helper::formatDateDiffInStrings($createdtime);
			$iconpath = 'layouts/v7/skins/images/moduleImages/'.$iconimagename;
			if(!file_exists($iconpath)){
				$iconpath = 'layouts/v7/skins/images/moduleImages/image.png';
			}
			$entitylabel = '<div id="bodyContent"><p>'.$action.' '.vtranslate($module,$module).' : </p><p><a href="'.$DetaiViewurl.'" target="_blank"><b>'.$label.' </b></a><p>'.$created_time.'</p></div>';

			$data[] = array('lat'=>(double)$latitude,'lng'=>(double)$longitude,'label'=>$label,'createdtime'=>$createdtime,'created_time'=>$created_time,'moduleimg'=>$iconpath,'action'=>$action,'modifiedby'=>$userName);

		}

		if($index && $size){
			if($recordsTotal > $index*$size){
				$isLast = false;
			}else{
				$isLast = true;
			}
		}


		$users = array();
		$USER_MODEL = Users_Record_Model::getCurrentUserModel();
		$AccessibleUsers = $USER_MODEL->getAccessibleUsers();
		foreach ($AccessibleUsers as $userid => $username) {
			array_push($users,array('id'=>$userid,'label'=>$username));
		}
		
		if(count($data) == 0){
			$message = $this->CTTranslate('No records found');
			$response->setResult(array('Data'=>array(),'code'=>404,'message'=>$message,'isLast'=>$isLast,'recordsTotal'=>$recordsTotal,'users'=>$users));
		}else{
			$response->setResult(array('Data'=>$data,'isLast'=>$isLast,'recordsTotal'=>$recordsTotal,'users'=>$users));
		}
		
		return $response;
	}
	
}
