/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouDescriptions license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

let ITS4YouMention_Hs = {

    initialize: function () {
        if ('Detail' !== app.getViewName()) {
            return;
        }

        this.retrieveMentionUsers();
        this.includeMentionJs();
        this.registerEvents();
    },
    registerReply: function (element) {
        const comment = element.parents('.singleComment'),
            creator = comment.find('.creatorName').text().trim(),
            editReason = comment.find('[name="reasonToEdit"]');

        if (creator && !editReason.length && !element.is('.replyUpdated')) {
            jQuery.each(this.getMentionUsers(), function (index, value) {
                if (value['name'].trim() === creator) {
                    element.addClass('replyUpdated');

                    return element.val('@' + value['username']);
                }
            });
        }
    },
    replaceCommentNames: function () {
        const self = this;

        jQuery('.commentInfoContent').not('.mentionReplace').each(function () {
            let comment = jQuery(this),
                users = self.getMentionUsers();

            jQuery.each(users, function (index, value) {
                comment.html(self.replaceUser(value, comment.html()));
                comment.data('fullcomment', self.replaceUser(value, comment.data('fullcomment')));
                comment.data('shortcomment', self.replaceUser(value, comment.data('shortcomment')));
            });

            if (users) {
                comment.addClass('mentionReplace');
            }
        });
    },
    replaceUser(user, comment) {
        if('undefined' !== typeof comment) {
            return comment.replace('@' + user['username'], '@' + user['name']);
        }

        return comment;
    },
    registerEvents: function () {
        const self = this,
            detailView = jQuery('.detailViewContainer');

        if (detailView.length) {
            detailView.on('focusin', '.commentcontent', function () {
                self.registerMention(jQuery(this));
                self.registerReply(jQuery(this));
            });

            jQuery(document).ajaxComplete(function () {
                self.replaceCommentNames();
            });
        }
    },
    registerMention: function (element) {
        const self = this;

        element.mention({
            delimiter: '@',
            sensitive: false,
            users: self.getMentionUsers(),
        });
    },
    mentionUsers: false,
    getMentionUsers: function () {
        return this.mentionUsers;
    },
    retrieveMentionUsers: function() {
        const self = this,
            params = {
                module: 'ITS4YouMention',
                action: 'Users',
                sourceModule: app.getModuleName(),
            };

        app.request.post({data: params}).then(function (error, data) {
            if (!error) {
                self.mentionUsers = data['users'];
            }
        });
    },
    includeMentionJs: function () {
        const scripts = [
            'modules/ITS4YouMention/resources/Mention-js/bootstrap-typeahead.js',
            'modules/ITS4YouMention/resources/Mention-js/mention.js',
            ],
            styles = [
                'modules/ITS4YouMention/resources/Mention-js/recommended-styles.css',
            ];

        jQuery(scripts).each(function(key, value) {
            jQuery('body').append('<script type="text/javascript" src="' + value + '"></script>');
        });
        jQuery(styles).each(function(key, value) {
            jQuery('body').append('<link type="text/css" rel="stylesheet" href="' + value + '">');
        });
    }
};

jQuery(function() {
    ITS4YouMention_Hs.initialize();
})