/**
 * VGS Dynamic Blocks
 *
 * @package        VGS Dynamic Blocks
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2014 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class("VGSDynamicBlocks_Js", {}, {
    bindEvents: function () {
        var record = jQuery('input:hidden[name=record]').val();
        params = {
            'module': 'VGSDynamicBlocks',
            'action': 'VGSDynamicBlocksColumnsAjax',
            'mode': 'getInitialFields',
            'vgsview': app.getViewName(),
            'sourcemodule': app.getModuleName(),
            'recordid': record
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {
                        blocks = data.result.blocks;
                        for (var i = 0; i < blocks.length; i++) {


                            if (jQuery('select[name=' + blocks[i]['fieldname'] + ']').val() === blocks[i]['fieldvalue']) {
                                var blockHeader = jQuery('.editViewContents').find('.fieldBlockHeader:contains("' + blocks[i]['blocklabel'] + '")');
                                if(blockHeader.html() == blocks[i]['blocklabel']){
                                    var table = blockHeader.closest('.fieldBlockContainer');
                                    blockHeader.find('*[data-rule-required=true]').each(function(){
                                        jQuery(this).attr('data-rule-required',false);
                                    });
                                    table.hide().next('br').hide();
                                }


                            }
                            jQuery('select[name=' + blocks[i]['fieldname'] + ']').on('change', function (e) {
                                var instance = new VGSDynamicBlocks_Js();
                                instance.updateBlocks(e);
                            });
                        }
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );
    },
    updateBlocks: function (e) {

        params = {
            'module': 'VGSDynamicBlocks',
            'action': 'VGSDynamicBlocksColumnsAjax',
            'mode': 'getblocks',
            'vgsview': app.getViewName(),
            'sourcemodule': app.getModuleName(),
            'fieldname': e.target.name,
            'fieldvalue': e.target.value
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {
                        var splitted = data.result.hiddenblocks;
                        for (var i = 0; i < splitted.length; i++) {
                            var blockHeader = jQuery(document).find('.fieldBlockHeader:contains("' + splitted[i] + '")');
                            if(blockHeader.html() == splitted[i]){
                                var table = blockHeader.closest('.fieldBlockContainer');
                                blockHeader.find('*[data-rule-required=true]').each(function(){
                                    jQuery(this).attr('data-rule-required',false);
                                });
                                table.hide().next('br').hide();
                            }
                            

                        }

                        var splitted = data.result.visibleblocks;
                        for (var i = 0; i < splitted.length; i++) {
                            var blockHeader = jQuery(document).find('.fieldBlockHeader:contains("' + splitted[i] + '")');
                            if(blockHeader.html() == splitted[i]){
                                var table = blockHeader.closest('.fieldBlockContainer');
                                blockHeader.find('*[data-rule-required=false]').each(function(){
                                    jQuery(this).attr('data-rule-required',true);
                                });
                                table.show().next('br').show();
                            }
                            
                        }
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );

    },
    updateBlocksDetail: function (e) {

        var is_summary = jQuery('.summaryView').length;

        params = {
            'module': 'VGSDynamicBlocks',
            'action': 'VGSDynamicBlocksColumnsAjax',
            'mode': 'getDetailBlocks',
            'is_summary': is_summary,
            'sourcemodule': app.getModuleName(),
            'vgsview':'Detail',
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {

                        if(is_summary){
                            console.log('WIP: Hidding the field in summary view');
                        }else{
                            blocks_info = data.result.hiddenblocks;
                            for (var i = 0; i < blocks_info.length; i++) {
                                var field_id = app.getModuleName() + '_detailView_fieldValue_' + blocks_info[i]['fieldname'];
                                if (jQuery.trim(jQuery('#' + field_id +' .value').text()) === blocks_info[i]['fieldvalue']) {
                                    var blockSelector = blocks_info[i]['blocklabel'].split(' ');
                                    var blockSelector = CSS.escape(blockSelector[0]).replace('\\','\\\\');
                                    var blockHeader = jQuery('.block_' + blockSelector);
                                    blockHeader.hide().next('br').hide();

                                }
                            }
                        }
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );

    },
    bindEventsDetailView: function () {
        var thisInstance = this;
        var record = jQuery('input:hidden[name=record]').val();
        params = {
            'module': 'VGSDynamicBlocks',
            'action': 'VGSDynamicBlocksColumnsAjax',
            'mode': 'getDetailBlocks',
            'sourcemodule': app.getModuleName(),
            'recordid': record
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {
                        blocks = data.result.hiddenblocks;
                        jQuery('#page').append('<input type="hidden" name="vgs_dyn_blocks" value="' + JSON.stringify(blocks) + '" />');
                    

                        app.event.on(Vtiger_Detail_Js.PostAjaxSaveEvent, function (e, fieldBasicData, postSaveRecordDetails,contentHolder) {
                            if(fieldBasicData.data('type') == 'picklist'){
                                for (var i = 0; i < blocks.length; i++) {
                                    if(fieldBasicData.data('name') === blocks[i]['fieldname']){
                                        jQuery('.block').show();
                                    }
                                }

                                for (var i = 0; i < blocks.length; i++) {
                                    if (fieldBasicData.data('value') === blocks[i]['fieldvalue']) {
                                        var blockHeader = jQuery('.block_' + blocks[i]['blocklabel']);
                                        blockHeader.hide().next('br').hide();
    
                                    }
                                }
                            }
                        });

                        

                        
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );
    }
});


jQuery(document).ready(function () {
    var instance = new VGSDynamicBlocks_Js();
    if (app.getViewName() === 'Edit') {
        instance.bindEvents();
    } else if (app.getViewName() === 'Detail') {
        instance.updateBlocksDetail();
        instance.bindEventsDetailView();
    }
    app.event.on('post.relatedListLoad.click',function(){
        instance.updateBlocksDetail();
        instance.bindEventsDetailView();
    });
});
