<?php

/**
 * Created by PhpStorm.
 * User: Stefan
 * Date: 25.05.2016
 * Time: 08:29
 */
namespace Workflow\CommunicationProvider;

use Workflow\ExecutionLogger;
use Workflow\VtUtils;

class ClockWorkSMS extends \Workflow\CommunicationPlugin
{
    protected $usernameLabel = 'API Key';
    protected $passwordLabel = 'API Key';

    protected $name = 'ClockWorkSMS.com';

    protected $supported = array(
        'sms' => true
    );

    private $client = null;

    public function SMS_check($data)
    {
        $this->connect();

        $username = $this->get('username');
        $password = $this->get('password');

        foreach($data as $message) {

            $params = array(
                'client' => array( 'username' => $username, 'password' => md5($password) ),
                'ids'    => $message->id
            );

            $result = $this->client->get_sms_by_ids($params);

            $statusCode = $result->status[0]->status;
            if($statusCode == '403') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': The message was sent but the operator has not yet attracted a delivery report.');
            }
            if($statusCode == '404') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message reached the recipient.');

                return true;
            }
            if($statusCode == '405') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message not delivered (eg .: the wrong number, number unavailable).');
            }
            if($statusCode == '406') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Error while sending the message (please report the problem to SMSAPI.pl).');
            }
            if($statusCode == '408') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message planned.');
            }
            if($statusCode == '410') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message received by the operator.');
            }
            if($statusCode == '411') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Was made the connection attempt has not been received, the call will be retried.');
            }

        }

        return false;
    }

    public function SMS($data) {
        if(substr($data['to'], 0, 2) == '00') {
            $data['to'] = ltrim($data['to'], '0');
        }

        if(empty($data['from'])) {
            $data['from'] = $this->get('default_from');
        }

        if(substr($data['from'], 0, 2) == '00') {
            $data['from'] = ltrim($data['from'], '0');
        }

        $data['to'] = ltrim($data['to'], '0+');
        $data['from'] = ltrim($data['from'], '0+');

        $password = $this->get('password');

        $parameter = array(
            'Key' => $password,
            'To'  => $data['to'],
            'From'=> $data['from'],
            'Content' => $data['content'],
            'Long' => 1,
        );

        $response = VtUtils::getContentFromUrl('https://api.clockworksms.com/http/send.aspx', $parameter, 'post');

        $parts = explode("\n", $response);

        if(strpos($parts[0], 'Error') !== false) {
         //   preg_match('/To\:\s+([a-zA-Z0-9+]+)](.*)/', $parts[0], $matches);
            throw new \Exception('ClockWorkSMS Error: '. $parts[0]);
        }
        preg_match('/ID\:\s+(.+)/', $parts[0], $matches);

        //return $matches[1];
    }

    public function test() {
        $password = $this->get('password');

        $parameter = array(
            'Key' => $password,
        );

        $response = VtUtils::getContentFromUrl('https://api.clockworksms.com/http/balance', $parameter, 'post');

        if(strpos($response, 'Error') !== false) {
            throw new \Exception('Wrong API Key');
        }


    }

    public function getConfigFields()
    {
        $return = parent::getConfigFields(); // TODO: Change the autogenerated stub
        unset($return['username']);
        $return['default_from'] = array(
            'label' => 'Default Sender',
            'type' => 'text',
        );


        return $return;
    }

    // Add Default Sender
    public function getDataFields($method) {
        $return = parent::getDataFields($method);
        $return['from']['placeholder'] = $this->get('default_from');

        return $return;
    }

}

\Workflow\CommunicationPlugin::register('clockworksms', '\\Workflow\\CommunicationProvider\\ClockWorkSMS');