<?php

/**
 * Created by PhpStorm.
 * User: Stefan
 * Date: 25.05.2016
 * Time: 08:29
 */
namespace Workflow\CommunicationProvider;

use Workflow\ExecutionLogger;
use Workflow\VtUtils;

class SMSApiPl extends \Workflow\CommunicationPlugin
{
    protected $usernameLabel = 'Username';
    protected $passwordLabel = 'Password';

    protected $name = 'SMSAPI.pl';

    protected $supported = array(
        'sms' => true
    );

    private $client = null;

    public function connect() {
        if(empty($this->client)) {
            try {
                $this->client = new \SoapClient( 'https://www.smsapi.pl/api/soap/v2/webservice?wsdl' , array(
                        'features'   => SOAP_SINGLE_ELEMENT_ARRAYS,
                        'cache_wsdl' => WSDL_CACHE_NONE,
                        'trace'      => true,
                    )
                );
            } catch (\SoapFault $sf) {
                throw new \Exception('Cannot connect to SMSAPI.pl');
            }
        }
    }

    public function SMS_check($data)
    {
        $this->connect();

        $username = $this->get('username');
        $password = $this->get('password');

        foreach($data as $message) {

            $params = array(
                'client' => array( 'username' => $username, 'password' => md5($password) ),
                'ids'    => $message->id
            );

            $result = $this->client->get_sms_by_ids($params);

            $statusCode = $result->status[0]->status;
            if($statusCode == '403') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': The message was sent but the operator has not yet attracted a delivery report.');
            }
            if($statusCode == '404') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message reached the recipient.');

                return true;
            }
            if($statusCode == '405') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message not delivered (eg .: the wrong number, number unavailable).');
            }
            if($statusCode == '406') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Error while sending the message (please report the problem to SMSAPI.pl).');
            }
            if($statusCode == '408') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message planned.');
            }
            if($statusCode == '410') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Message received by the operator.');
            }
            if($statusCode == '411') {
                ExecutionLogger::getCurrentInstance()->log($message->id.': Was made the connection attempt has not been received, the call will be retried.');
            }

        }

        return false;
    }

    public function SMS($data) {
        $this->connect();

        if(empty($data['from'])) {
            $data['from'] = $this->get('default_from');
        }

        if(substr($data['to'], 0, 2) == '00') {
            $data['to'] = '+'.ltrim($data['to'], '0');
        }

        if(substr($data['from'], 0, 2) == '00') {
            $data['from'] = '+'.ltrim($data['from'], '0');
        }

        $sms = array(
            'sender'    => 'SMSAPI',
            'recipient' => $data['to'],
            'sender' => $data['from'],
            'eco'       => 0,
            'date_send' => 0,
            'details'   => 1,
            'message'   => $data['content'],
//            'params'    => array( 'parametr 1', 'parametr 2', 'parametr 3', 'parametr 4'),
            'idx'       => uniqid(),
        );

        $username = $this->get('username');
        $password = $this->get('password');

        $params = array(
            'client' => array( 'username' => $username, 'password' => md5($password) ),
            'sms'    => $sms
        );

        $result = $this->client->send_sms($params);

        return $result->response;
    }

    public function test() {
        $this->connect();

        $username = $this->get('username');
        $password = $this->get('password');

        $params = array( 'username' => $username, 'password' => md5($password) );

        $response = $this->client->get_points($params);
    }

    public function getConfigFields()
    {
        $return = parent::getConfigFields(); // TODO: Change the autogenerated stub
        $return['default_from'] = array(
            'label' => 'Default Sender',
            'type' => 'text',
        );

        return $return;
    }

    // Add Default Sender
    public function getDataFields($method) {
        $return = parent::getDataFields($method);
        $return['from']['placeholder'] = $this->get('default_from');
        return $return;
    }

}

\Workflow\CommunicationPlugin::register('smsapipl', '\\Workflow\\CommunicationProvider\\SMSApiPl');