<?php
require_once(realpath(dirname(__FILE__).'/../autoload_wf.php'));

class WfTaskCallWebservice extends \Workflow\Task
{
    protected $_javascriptFile = "WfTaskCallwebservice.js";

    public function getEnvironmentVariables()
    {
        $return = parent::getEnvironmentVariables(); // TODO: Change the autogenerated stub

        if($this->get('envvar') != -1 && $this->get('envvar') != '') {
            $return[] = "['".$this->get('envvar')."'";
        }

        return $return;

    }

    function http_build_query_for_curl( $arrays, &$new = array(), $prefix = null ) {

        if ( is_object( $arrays ) ) {
            $arrays = get_object_vars( $arrays );
        }

        foreach ( $arrays AS $key => $value ) {
            $k = isset( $prefix ) ? $prefix . '[' . $key . ']' : $key;
            if ( is_array( $value ) OR is_object( $value )  ) {
                $this->http_build_query_for_curl( $value, $new, $k );
            } else {
                $new[$k] = $value;
            }
        }
    }

    public function handleTask(&$context) {
        $values = $this->get("cols");
        $header = $this->get("header");

        $query = array();
        $objTemplate = new VTTemplate($context);
        foreach($values["key"] as $index => $value) {
            $keyValue = $objTemplate->render($values["value"][$index]);
            $query[$value] = $keyValue;
        }

        if($this->notEmpty('inventoryvar')) {
            $var = $this->get('inventoryvar');
            $inventory = $context->exportInventory();
            $query[$var] = $inventory;
        }

        $url = $this->get('url');
        $url = str_replace('%', '(-[ayc]-)', $url);
        $url = \Workflow\VTTemplate::parse($url, $context);
        $url = str_replace('(-[ayc]-)', '%', $url);

        $method = $this->get('method');

        $options = array();

        if($header != -1 && !empty($header)) {
            foreach($header["key"] as $index => $value) {
                $keyValue = $objTemplate->render($header["value"][$index]);
                $options['headers'][] = $value.': '.$keyValue;
            }
        }

        $parameterform = $this->get('parameterformat');

        if($parameterform == 'json') {
            $options['headers'][] = 'Content-Type: application/json';
            $query = json_encode($query);
        } else {
            $new = array();
            $this->http_build_query_for_curl($query, $new);
            $query = $new;
        }

        $this->addStat('Method / URL: '. $method . ' ' . $url);
        $this->addStat('Query:');
        $this->addStat($query);
        $this->addStat('Options:');
        $this->addStat($options);

        switch($method) {
            case 'POST':
            case 'GET':
                $content = \VtUtils::getContentFromUrl($url, $query, $method, $options);
                break;
        }

        if($this->get('envvar') != -1 && $this->get('envvar') != '') {
            $responseType = $this->get('responsetype');
            switch($responseType) {
                case 'json':
                    $content = \Workflow\VtUtils::json_decode($content);
                    break;
            }

            $context->setEnvironment($this->get('envvar'), $content);
        }

//        var_dump($method, $url, $query);
//        var_dump($content);

        return "yes";
    }
	
    public function beforeGetTaskform($viewer) {
        $pause_rows = $this->get("pause_rows");
        if($pause_rows == -1) {
            $this->set("pause_rows", 50);
        }

        $cols = $this->get("cols");
        $header = $this->get("header");

        if($cols == -1) {
            $cols = array();
        }

        if($cols == -1) {
            $header = array();
        }

        foreach($cols["key"] as $index => $col) {
            if(empty($col)) {
                unset($cols["key"][$index]);
                unset($cols["value"][$index]);
            }
        }
        foreach($header["key"] as $index => $col) {
            if(empty($col)) {
                unset($header["key"][$index]);
                unset($header["value"][$index]);
            }
        }

        $viewer->assign("cols", $cols);
        $viewer->assign("header", $header);

        $viewer->assign("webservice_methods", array('POST' => 'POST', 'GET' => 'GET'));

        $viewer->assign('SHOW_INVENTORY', \Workflow\VtUtils::isInventoryModule($this->getModuleName()));

		/* Insert here source code to create custom configurations pages */
    }	
    public function beforeSave(&$values) {
		/* Insert here source code to modify the values the user submit on configuration */
    }	
}
