<?php
require_once(realpath(dirname(__FILE__).'/../autoload_wf.php'));

class WfTaskOwnCloud_deleteshare extends \Workflow\Task
{
    /**
     * @var \Workflow\Preset\SimpleConfig
     */
    private $_SC = null;

    public function init()
    {
        $this->_SC = $this->addPreset("SimpleConfig", "details", array(
            'templatename' => 'mainconfig',
        ));

        if($this->isConfiguration()) {
            $this->_SC->setColumnCount(1);

            $this->_SC->addFields('providerid', 'OwnCloud Provider', 'provider', array(
                'provider' => 'owncloud'
            ));

            $this->_SC->addFields('id', 'ID', 'template');
        }

    }
    public function handleTask(&$context) {

        if($this->_SC->has('providerid')) {
            /**
             * @var $provider \Workflow\Plugins\ConnectionProvider\OwnCloud
             */
            $provider = \Workflow\ConnectionProvider::getConnection($this->_SC->get('providerid'));

            $provider->DeleteShare(
                $this->_SC->get('id')
            );

        }

        return "yes";
    }

    public function beforeGetTaskform($viewer) {
        /* Insert here source code to create custom configurations pages */
    }
    public function beforeSave(&$values) {
        /* Insert here source code to modify the values the user submit on configuration */
    }
}
